/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytania 13.8 i 13.9)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdio.h>
#include <string.h>

/* porwnanie napisw poprzez wskaniki */
int pstrcmp(const void *p1, const void *p2)
{
	return strcmp(*(char * const *)p1, *(char * const *)p2);
}

#define NSTRINGS 10

void test1()
{
int i;
#include <stdlib.h>
char *strings[NSTRINGS];
int nstrings;
strings[0] = "to";
strings[1] = "jest";
strings[2] = "tylko";
strings[3] = "test";
nstrings = 4;
/* sortujemy nstrings elementw tablicy strings */
qsort(strings, nstrings, sizeof(char *), pstrcmp);
for(i = 0; i < nstrings; i++)
	printf("%s\n", strings[i]);
}

struct mystruct {
	int year, month, day;
};

int mystructcmp(const void *p1, const void *p2)
{
	const struct mystruct *sp1 = p1;
	const struct mystruct *sp2 = p2;
	/* porwnujemy kolejne pola sp1 and sp2... */
	if(sp1->year < sp2->year) return -1;
	else if(sp1->year > sp2->year) return 1;
	else if(sp1->month < sp2->month) return -1;
	else if(sp1->month > sp2->month) return 1;
	else if(sp1->day < sp2->day) return -1;
	else if(sp1->day > sp2->day) return 1;
	else return 0;
}

#define NDATES 10

#include <stdlib.h>
struct mystruct dates[NDATES];
int ndates;

void test2()
{
int i;

dates[0].year = 1995; dates[0].month = 10; dates[0].day = 2;
dates[1].year = 1994; dates[1].month = 10; dates[1].day = 1;
dates[2].year = 1996; dates[2].month = 1; dates[2].day = 1;
dates[3].year = 1995; dates[3].month = 10; dates[3].day = 1;
dates[4].year = 1994; dates[4].month = 10; dates[4].day = 1;
dates[5].year = 1900; dates[5].month = 1; dates[5].day = 1;

ndates = 6;

/* sortujemy ndates elemntw tablicy dates[] */
qsort(dates, ndates, sizeof(struct mystruct), mystructcmp);

for(i = 0; i < ndates; i++)
	printf("%d-%02d-%02d\n", dates[i].year, dates[i].month, dates[i].day);
}

int myptrstructcmp(const void *p1, const void *p2)
{
	struct mystruct *sp1 = *(struct mystruct * const *)p1;
	struct mystruct *sp2 = *(struct mystruct * const *)p2;

	if(sp1->year < sp2->year) return -1;
	else if(sp1->year > sp2->year) return 1;
	else if(sp1->month < sp2->month) return -1;
	else if(sp1->month > sp2->month) return 1;
	else if(sp1->day < sp2->day) return -1;
	else if(sp1->day > sp2->day) return 1;
	else return 0;
}

void test3()
{
int i;

struct mystruct *dateptrs[NDATES];
int ndates;

dateptrs[0] = &dates[4];
dateptrs[1] = &dates[2];
dateptrs[2] = &dates[1];
dateptrs[3] = &dates[3];
dateptrs[4] = &dates[0];
dateptrs[5] = &dates[5];

ndates = 6;

for(i = 0; i < ndates; i++)
	printf("%d-%02d-%02d\n", dateptrs[i]->year, dateptrs[i]->month, dateptrs[i]->day);

qsort(dateptrs, ndates, sizeof(struct mystruct *), myptrstructcmp);

for(i = 0; i < ndates; i++)
	printf("%d-%02d-%02d\n", dateptrs[i]->year, dateptrs[i]->month, dateptrs[i]->day);
}

main()
{
test1();
printf("\n");
test2();
printf("\n");
test3();
return 0;
}
